# 星青创聚合登录 JavaScript SDK

## 安装

### 浏览器环境
```html
<script src="oauth.js"></script>
```

### Node.js 环境
```javascript
const OAuth = require('./oauth.js');
```

## 快速开始

```javascript
const oauth = new OAuth({
    apiurl: 'https://login.xingqingchuang.com',
    appid: '您的APPID',
    appkey: '您的APPKEY',
    callback: 'https://您的网站/callback',
});

// 发起QQ登录
oauth.login('qq').then(result => {
    if (result.code === 0) {
        window.location.href = result.url;
    }
});
```

## 回调处理

```javascript
// 获取URL参数中的code
const urlParams = new URLSearchParams(window.location.search);
const code = urlParams.get('code');

// 获取用户信息
oauth.callback(code).then(result => {
    if (result.code === 0) {
        console.log('用户ID:', result.social_uid);
        console.log('昵称:', result.nickname);
        console.log('头像:', result.faceimg);
    }
});
```

## 支持的登录类型

| type | 平台 |
|------|------|
| qq | QQ登录 |
| wx | 微信登录 |
| alipay | 支付宝登录 |
| sina | 微博登录 |
| github | GitHub登录 |
| ... | 更多平台 |
